// Filter.h: interface for the CFilter class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_FILTER_H__1E9361A8_4D57_42D8_BE64_0C93F95AEB83__INCLUDED_)
#define AFX_FILTER_H__1E9361A8_4D57_42D8_BE64_0C93F95AEB83__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


#define	ITEM_GOLD1		0
#define	ITEM_GOLD2		1
#define	ITEM_GOLD3		2
#define	ITEM_GOLD4		3
#define	ITEM_GOLD5		4

#define	ITEM_HEALING1	5
#define	ITEM_HEALING2	6
#define	ITEM_HEALING3	7
#define	ITEM_HEALING4	8
#define	ITEM_HEALING5	9

#define	ITEM_MANA1		10
#define	ITEM_MANA2		11
#define	ITEM_MANA3		12
#define	ITEM_MANA4		13
#define	ITEM_MANA5		14

#define	ITEM_REJUV1		15
#define	ITEM_REJUV2		16

#define	ITEM_RUNE1		17
#define	ITEM_RUNE2		18
#define	ITEM_RUNE3		19
#define	ITEM_RUNE4		20
#define	ITEM_RUNE5		21

#define	ITEM_JEWLRY		22

#define	ITEM_GEM1		23
#define	ITEM_GEM2		24
#define	ITEM_GEM3		25
#define	ITEM_GEM4		26
#define	ITEM_GEM5		27

#define	ITEM_SKULL1		28
#define	ITEM_SKULL2		29
#define	ITEM_SKULL3		30
#define	ITEM_SKULL4		31
#define	ITEM_SKULL5		32

#define	ITEM_JEWELS		33
#define	ITEM_CHARMS		34
#define	ITEM_TP			35
#define	ITEM_ID			36
#define	ITEM_UBER		37

#define NUM_ITEMS		38


#define RUNE_EL			1
#define RUNE_ELD		2
#define RUNE_TIR		3
#define RUNE_NEF		4
#define RUNE_ETH		5
#define RUNE_ITH		6
#define RUNE_TAL		7
#define RUNE_RAL		8
#define RUNE_ORT		9
#define RUNE_THUL		10
#define RUNE_AMN		11
#define RUNE_SOL		12
#define RUNE_SHEA		13
#define RUNE_DOL		14
#define RUNE_HEL		15
#define RUNE_IO			16
#define RUNE_LUM		17
#define RUNE_KO			18
#define RUNE_FAL		19
#define RUNE_LEM		20
#define RUNE_PUL		21
#define RUNE_UM			22
#define RUNE_MAL		23
#define RUNE_IST		24
#define RUNE_GUL		25
#define RUNE_VEX		26
#define RUNE_OHM		27
#define RUNE_LO			28
#define RUNE_SUR		29
#define RUNE_BER		30
#define RUNE_JO			31
#define RUNE_CHAM		32
#define RUNE_ZOD		33


class CFilterClass
{
public:
	int			m_MaxPickRange ;
	int			m_CascadeMin ;
	int			m_CascadeMax ;
	int			m_FilterValue ;
	int			m_PriorityColor ;
} ;

class CFilter  
{
public:
	CFilterClass	m_Filter[NUM_ITEMS] ;

	CBitmap		m_bmpColor[5] ;
	CBitmap		m_FilterBMPs[NUM_ITEMS] ;
	CBitmap		m_RuneBuffer ;		// need to go +1 for a buffer zone when deleting
	CBitmap		m_RuneBMP ;


	CFilter();
	virtual ~CFilter();

	void LoadBMPs( BOOL bGfxLite) ;
	CString UpdateRunePic( int val, BOOL bGfxLite) ;
	CString GetRuneName( int runeNumber) ;

	void PreCannedValues() ;
	void RetrieveValues() ;

	CString AddSpecialFilter( int iFilter, int iValue, BOOL bGotInt) ;
	int DelSpecialFilter( int iFilter) ;
	void CascadeUpdate( int iFilter, int iRange) ;
	void DrawFilter(int iMin, int iMax, int iXPos, int iOffSet, BOOL bSpecial, CDC* memdc, CPaintDC* dc, BOOL bGfxLite) ;
};

#endif // !defined(AFX_FILTER_H__1E9361A8_4D57_42D8_BE64_0C93F95AEB83__INCLUDED_)
